/* Copyright (C) 2011-2018 RealVNC Ltd. All Rights Reserved.
 *
 * This is sample code intended to demonstrate part of the
 * VNC Mobile Solution SDK. It is not intended as a production-ready
 * component.
 */

#include <assert.h>

#ifndef _MSC_VER
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#endif

#include <SignalEvent.h>
#include <DiscoveryException.h>

using namespace vncdiscovery;

SignalEvent::SignalEvent()
{
  VNCDiscovererEventHandle fds[2];
  if(pipe(fds) != 0)
  {
    throw DiscoveryException("Unable to create the pipe needed by eventFd",
                                  errno);
  }
  mPipeReadFd = fds[0];
  mPipeWriteFd = fds[1];

  int flags = fcntl(mPipeReadFd, F_GETFL);
  if(0 != fcntl(mPipeReadFd, F_SETFL, flags | O_NONBLOCK))
  {
    ::close(mPipeReadFd);
    mPipeReadFd = VNCDiscovererNoEventHandle;
    ::close(mPipeWriteFd);
    mPipeWriteFd = VNCDiscovererNoEventHandle;
    throw DiscoveryException("Unable set the read file descriptor to "
          "non-blocking for the eventFd", errno);
  }
}

SignalEvent::~SignalEvent()
{
  if(mPipeReadFd != VNCDiscovererNoEventHandle)
    ::close(mPipeReadFd);
  if(mPipeWriteFd != VNCDiscovererNoEventHandle)
    ::close(mPipeWriteFd);
}

bool SignalEvent::wasSignalled()
{
  char c;
  return read(mPipeReadFd, &c, 1) == 1;
}

VNCDiscovererEventHandle& SignalEvent::getEventHandle()
{
  return mPipeReadFd;
}

void SignalEvent::signal()
{
  char c = 0;
  if(write(mPipeWriteFd, &c, 1) < 0)
  {
    // Do nothing
  }
}

